import { IsInt, IsOptional, IsString, Max, Min } from 'class-validator';

export class CreateNotificationFeedbackDto {
  @IsInt()
  userNotificationId: number;

  @IsInt()
  @Min(1)
  @Max(5)
  rating: number;

  @IsOptional()
  @IsString()
  note?: string;
}
